<?php

namespace App\Repositories;
use Exception;
use App\Models\User;
use App\Mail\NewUserRegistered;
use App\Interfaces\UserInterface;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;

class UserRepository implements UserInterface
{
    public  function getAllUsers($search=null)
    {
        try {

            if($search==null){
                $users = User::with('roles')->paginate(10);
                //dd($users);
            }
            else{
                $users=User::where('name', 'LIKE','%'.$search.'%')
                    ->orWhere('email', 'LIKE','%'.$search.'%')
                    ->with('roles')
                    ->orderBy("id","desc")->paginate(10);
            }
            //dd($users);
            return $users;
        }catch(Exception $e){
            dd($e->getMessage());
           // Log::error("Error getting all users".$e->getMessage());
            //throw new \Exception('Error retrieving users', 500);
        }
    }
    public function createUser($data)
    {
        DB::beginTransaction();
        try{
            $password=$data['password'];
            $user=User::create($data);
            $user->assignRole($data['role']);
            Mail::to($user->email)->send(new NewUserRegistered($user, $password));
            DB::commit();
            return true;

        }
        catch(QueryException $ex){
            DB::rollBack();
            Log::error("Error creating user".$ex->getMessage());
            return false;
        }
        catch(Exception $ex){

            Log::error("General error" . $ex->getMessage());
            return false;
        }


    }

    public function countUsers($role=null)
    {
        if ($role == null){
           return User::count();
        }else{
            return User::role($role)->count();
        }
    }
    public function getUserData($id){
        $user = User::with('roles')->findOrFail($id);
        return $user;
    }
    public function updateUser($request,$id){
        try{

            $user = User::whereId($id)->first();
            if (!empty($request['password'])) {
                //dd($request['password']);
                $user->name = $request['name'];
                $user->email = $request['email'];
                $user->password = bcrypt($request['password']);
            } else {
                $user->name = $request['name'];
                $user->email = $request['email'];
            }
            $user->update();
            $user->syncRoles($request['role']);
            return true;
        }catch(Exception $ex){
            //dd($ex->getMessage(),$ex->getLine());
            Log::error("Error getting Updating user" . $ex->getMessage());
            return false;
        }

    }
    public function updateProfile($request, $id)
    {
        try {

            $user = User::whereId($id)->first();
            if (!empty($request['password'])) {
                //dd($request['password']);
                $user->name = $request['name'];
                $user->email = $request['email'];
                $user->password = bcrypt($request['password']);
            } else {
                $user->name = $request['name'];
                $user->email = $request['email'];
            }
            $user->update();

            return true;
        } catch (Exception $ex) {
            //dd($ex->getMessage(),$ex->getLine());
            Log::error("Error getting Updating user" . $ex->getMessage());
            return false;
        }
    }
    public function deleteUser($id){
        try{
            $user = User::findOrFail($id);
            $user->delete();
            return true;
        }catch(Exception $ex){
            Log::error("Error while deleting user" . $ex->getMessage());
            return false;
        }

    }
}
