<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booths', function (Blueprint $table) {
            $table->id();
            $table->string('number');
            $table->string('size')->nullable();
            $table->string('exhibitor_name');
            $table->foreignId('event_id')->constrained()->onDelete('cascade');
            $table->foreignId('hall_id')->constrained();
            $table->boolean('disposeable')->default(false);
            $table->enum('result',['GOLD', 'BRONZE', 'SILVER', 'DISPOSABLE','NOT'])->default('NOT');
            $table->boolean('draft')->default(false);
            $table->unsignedInteger('assesment_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booths');
    }
};
