<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roleSuperAdmin = Role::create(['name' => 'Super Admin']);
        $roleAdmin = Role::create(['name' => 'Admin']);
        $roleUser = Role::create(['name' => 'User']);
        $roleOrganizer = Role::create(['name' => 'Organizer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $permissionsAdmin= Permission::where('name', '!=', 'admin-delete')->where('name', '!=', 'admin-edit')->where('name','!=', 'role-management')->pluck('id');
        $roleUser->syncPermissions(['view-event', 'booth-list', 'add-rating', 'view-rating', 'booth-hall-edit']);
        $roleAdmin->syncPermissions($permissionsAdmin);
        $roleSuperAdmin->syncPermissions($permissions);
        $admin = User::create([
            'name' => 'Admin admin',
            'email' => 'admin@gmail.com',
            'password' => bcrypt('123456')
        ]);
        $admin->assignRole([$roleAdmin->id]);
        $super = User::create([
            'name' => 'Super admin',
            'email' => 'super@gmail.com',
            'password' => bcrypt('123456')
        ]);
        $super->assignRole([$roleSuperAdmin->id]);
        $user = User::create([
            'name' => 'Test user',
            'email' => 'user@gmail.com',
            'password' => bcrypt('123456')
        ]);
        $user->assignRole([$roleUser->id]);
    }
}
